﻿Imports System
Imports System.Collections

' Klasa FlightSegment deleguje operację CheckLuggage
' do klasy LuggageCompartment.
Public Class FlightSegment
    ' Obiekt myLuggageCompartment reprezentuje luk bagażowy, w którym
    ' są przewożone bagaże w ramach bieżącego lotu.
    Private myLuggageCompartment As LuggageCompartment

    ' Konstruktor dla nowego egzemplarza klasy FlightSegment
    Public Sub New()
        myLuggageCompartment = New LuggageCompartment()
    End Sub 'New

    ' Rezerwuje przestrzeń dla bagażu transportowanego w ramach danego lotu.
    Public Sub CheckLuggage(ByVal piece As Luggage)
        myLuggageCompartment.CheckLuggage(piece)
    End Sub 'CheckLuggage
End Class 'FlightSegment

' Poniżej zdefiniowano klasę LuggageCompartment, która deleguje zadania
' związane z obsługą kolekcji bagaży do egzemplarza klasy ArrayList.
Public Class LuggageCompartment
    ' Kolekcja reprezentująca bagaże, dla których zarezerwowano miejsce w luku.
    Private pieces As New ArrayList()

    ' Łączna waga bagażuów.
    Private myWeight As Single

    ' Rezerwuje miejsce w luku bagażowym.
    Public Sub CheckLuggage(ByVal thePiece As Luggage)
        Dim newWeight As Single = thePiece.Weight + myWeight
        SyncLock pieces
            pieces.Add(thePiece)
        End SyncLock
        myWeight = newWeight
    End Sub 'CheckLuggage
End Class 'LuggageCompartment

'
' a container for luggage information
'
Public Class Luggage
    Private myWeight As Single

    ' weight of this item of luggage
    Public Property Weight() As Single
        Get
            Return myWeight
        End Get
        Set(ByVal value As Single)
            myWeight = value
        End Set
    End Property
End Class 'Luggage
